#pragma once

#ifndef _COMPILING_CHIP8
//#pragma message(__FILE__ ": Trying to include header file elsewhere than from Chip8 Emulator.cpp!")
#error Fatal error: Trying to include header file elsewhere than from Chip8 Emulator.cpp!
#endif

uint HP48Pointer = 0x130;	// ???
uint iRoutinesJumped = 0;	// How many sub-routines are we in right now?
uint I = 0;					// Memory position
byte V[16];					// Registers
byte memory[0xFFF];			// Memory
byte screen[0x2000+1];		// Screen
uint PC = 0x200;			// Position counter
uint DT = 0;				// Delay timer
uint ST = 0;				// Sound timer
uint nRegDelay = 20;		// Register delay
bool bExtendedScreen = false; // SuperChip8 only
bool bRealQuit = false;
uint stack[16];				// Stack
DWORD dwPixelColor = 0xFFFF0000;

WORD opcode;				// Opcode, what else? Duh!
uint rom_length = 0;		// Rom length
bool bExit = false;
__int64 signature;			// First 8 bytes of rom; used for hacks
bool keys[16];

// Debug variables
WORD lastOpcode = 0;
uint lastPC = 0;
uint StopPC = 0;			 // Stops execution at specified address. Set to 0 if no breakpoint is to be set.
uint StopDrawCalltimes = 0;  //34;		// Stop when the draw sprite function has been called X number of times. Function will return immidietly after number has been reached.
bool bOnlyOpcodes = true;		 // Debug output only for opcodes
bool bMonitorDrawOpcode = false; // Monitor draw opcodes? (0xD000)
bool bMonitorRegisterI = false;  // Monitor the I register?
bool bDebugOutput = false;		 // Specifies if debug data is to be outputted

//vector<WORD> OpCodes;
// Debug variables end

byte Chip8Font[80] =
{ 
    0xF0, 0x90, 0x90, 0x90, 0xF0, // 0
    0x20, 0x60, 0x20, 0x20, 0x70, // 1
    0xF0, 0x10, 0xF0, 0x80, 0xF0, // 2
    0xF0, 0x10, 0xF0, 0x10, 0xF0, // 3
    0x90, 0x90, 0xF0, 0x10, 0x10, // 4
    0xF0, 0x80, 0xF0, 0x10, 0xF0, // 5
    0xF0, 0x80, 0xF0, 0x90, 0xF0, // 6
    0xF0, 0x10, 0x20, 0x40, 0x40, // 7
    0xF0, 0x90, 0xF0, 0x90, 0xF0, // 8
    0xF0, 0x90, 0xF0, 0x10, 0xF0, // 9
    0xF0, 0x90, 0xF0, 0x90, 0x90, // A
    0xE0, 0x90, 0xE0, 0x90, 0xE0, // B
    0xF0, 0x80, 0x80, 0x80, 0xF0, // C
    0xE0, 0x90, 0x90, 0x90, 0xE0, // D
    0xF0, 0x80, 0xF0, 0x80, 0xF0, // E
    0xF0, 0x80, 0xF0, 0x80, 0x80  // F
};

byte SChip8Font[160]=
{ 
	//0x00, 0x7E, 0xFF, 0xE7, 0xE7, 0xE7, 0xE7, 0xFF, 0x7E, 0x00,
	0xF0, 0xF0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0xF0, 0xF0, // 0
    0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x70, 0x70, // 1
    0xF0, 0xF0, 0x10, 0x10, 0xF0, 0xF0, 0x80, 0x80, 0xF0, 0xF0, // 2
    0xF0, 0xF0, 0x10, 0x10, 0xF0, 0xF0, 0x10, 0x10, 0xF0, 0xF0, // 3
    0x90, 0x90, 0x90, 0x90, 0xF0, 0xF0, 0x10, 0x10, 0x10, 0x10, // 4
    0xF0, 0xF0, 0x80, 0x80, 0xF0, 0xF0, 0x10, 0x10, 0xF0, 0xF0, // 5
    0xF0, 0xF0, 0x80, 0x80, 0xF0, 0xF0, 0x90, 0x90, 0xF0, 0xF0, // 6
    0xF0, 0xF0, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x40, 0x40, // 7
    0xF0, 0xF0, 0x90, 0x90, 0xF0, 0xF0, 0x90, 0x90, 0xF0, 0xF0, // 8
    0xF0, 0xF0, 0x90, 0x90, 0xF0, 0xF0, 0x10, 0x10, 0xF0, 0xF0, // 9
    0xF0, 0xF0, 0x90, 0x90, 0xF0, 0xF0, 0x90, 0x90, 0x90, 0x90, // A
    0xE0, 0xE0, 0x90, 0x90, 0xE0, 0xE0, 0x90, 0x90, 0xE0, 0xE0, // B
    0xF0, 0xF0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xF0, 0xF0, // C
    0xE0, 0xE0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0xE0, 0xE0, // D
    0xF0, 0xF0, 0x80, 0x80, 0xF0, 0xF0, 0x80, 0x80, 0xF0, 0xF0, // E
    0xF0, 0xF0, 0x80, 0x80, 0xF0, 0xF0, 0x80, 0x80, 0x80, 0x80  // F
};